/******************************************************************************
* FILE:   tetris_brick.h
*         Definition of the class Tetris_brick.
*
* Author: Dana Vrajitoru, IUSB
* Class:  C481 B581 Computer Graphics
******************************************************************************/

#ifndef TETRIS_BRICK_H
#define TETRIS_BRICK_H

#include "table.h"

const int BRICK_NR = 4;

enum Brick_type { long_shape, l_shape, s_shape, square_shape, t_shape};

class Tetris_brick {
 public:
  int pos_x, pos_y;
  int orientation;
  Brick_type shape;
  int bricks[BRICK_NR][2];

  // Constructor with a given shape and orientation.
  Tetris_brick(Brick_type the_shape, int the_orientation = 0);
  // Default constructor that generates a random brick.
  Tetris_brick();
  // Copy constructor
  Tetris_brick(const Tetris_brick &data);

  // Destructor: nothing to do.
  ~Tetris_brick();

  // Sets the intial position of the brick in the game.
  void Set_initial_pos(int width=T_WIDTH);

  // Set the position of the brick to the given values.
  void Set_position(int x, int y);

  // Reinitialize the brick with the shape and orientation.
  void Set_brick(Brick_type the_shape, int the_orientation = 0);
  // Reinitialize the brick randomly.
  void Set_brick();
  // Copies the data from the second brick.
  void Set_brick(const Tetris_brick &data);

  // Flip the brick vertically
  void Flip_vertical();

  // Flip the brick horizontally
  void Flip_horizontal();

  // Rotate the brick counterclockwise
  void Rotate_CCW();

  // Rotate the brick clockwise
  void Rotate_CW();

  // Reset all the bricks to the position (0,0)
  void Reset_bricks();

  // Compute the max position of a brick in the specified dimension.
  int Max_dim(int which); 

  // Checks if the brick fits in the table at the given position.
  int Check_position(Table_type table, int x, int y);

  // Checks if the brick fits in the table at the given position.
  int Check_position(Table_type table);

  // Moves the brick down by 1 position if possible. Returns 1 or 0 to
  // say if the movement was possible or not.
  int Move_down(Table_type table);

  // Moves the brick down by 1 position if possible. Returns 1 or 0 to
  // say if the movement was possible or not.
  int Move_left(Table_type table);

  // Moves the brick down by 1 position if possible. Returns 1 or 0 to
  // say if the movement was possible or not.
  int Move_right(Table_type table);

  // Write the brick to the table.
  int Write_brick(Table_type table);
};

#endif
