/******************************************************************************
* FILE:   table.h
*         The functions that handle the game table.
*
* Author: Dana Vrajitoru, IUSB
* Class:  C481 B581 Computer Graphics
******************************************************************************/

#ifndef TABLE_H
#define TABLE_H

const int T_WIDTH = 14, T_HEIGHT = 21;
const int C_WIDTH = 10, C_HEIGHT = 10;

enum Cell_type {space_cell, brick_cell, wall_cell};

typedef Cell_type Table_type[T_WIDTH][T_HEIGHT];

// Makes an empty table with walls all around.
void Make_empty_table(Table_type table, 
		      int width=T_WIDTH, int height=T_HEIGHT);
// checks if a row in the table is complete and if it is, it removes
// it. It returns 1 if the row has been removed, 0 otherwise.
int Check_remove_row(int row, Table_type table, 
		     int width=T_WIDTH, int height=T_HEIGHT);

#endif
