/******************************************************************************
* FILE:   table.cc
*         The functions that handle the game table.
*
* Author: Dana Vrajitoru, IUSB
* Class:  C481 B581 Computer Graphics
******************************************************************************/

#include "table.h"

// Makes an empty table with walls all around.
void Make_empty_table(Table_type table, int width, int height)
{
  int x, y;
  for (x=1; x<width-1; x++)
    for (y=0; y<height-1; y++)
      table[x][y] = space_cell;
  for (y=0; y<height; y++) {
    table[0][y] = wall_cell;
    table[width-1][y] = wall_cell;
  }
  for (x=1; x<width-1; x++)
    table[x][height-1] = wall_cell;
}

// checks if a row in the table is complete and if it is, it removes
// it. It returns 1 if the row has been removed, 0 otherwise.
int Check_remove_row(int row, Table_type table, int width, int height)
{
  for (int i=0; i<width; i++)
    if (table[i][row] == space_cell)
      return 0;
  for (int j=row; j>0; j--)
    for (int i=0; i<width; i++) 
      if (table[i][j] != wall_cell) {
	if (table[i][j-1] == wall_cell)
	  table[i][j] = space_cell;
	else 
	  table[i][j] = table[i][j-1];
      }
  for (int i=0; i<width; i++) 
    if (table[i][0] != wall_cell)
      table[i][0] = space_cell;
  return 1;
}
