/******************************************************************************
* FILE:   menu_handle.cc
*         Some functions to create and manage menu for a gnome application.
*
* Author: Dana Vrajitoru, IUSB
* Class:  C481 B581 Computer Graphics
******************************************************************************/

#include "menu_handle.h"

// Adding a menu item that causes to exit the application.  The where
// parameter is the index in the array of menu items where the exit
// item is placed.
void Menu_add_exit(GnomeUIInfo *menu, int where)
{
  GnomeUIInfo item[] = GNOMEUIINFO_MENU_EXIT_ITEM(gtk_main_quit, NULL);
  menu[where] = item[0];
}

// Add a simple item to the menu at the position indicated by
// where. There is no icon display on the item line, nor shortcut key,
// and no data to be passed to the callback function. The label is
// what will appear in this place in the menu (place an underline
// before the character in the label to be used as meta (accelerator)
// character for the item. The tooltip is a comment that appears in
// the status bar if the application defines one. The last parameter
// is the name of the function to be called when the menu item is
// activated.
void Menu_add_item_simple(GnomeUIInfo *menu, int where,
			  gchar *label, gchar *tooltip,
			  void (*a_callback) (GtkWidget*, gpointer))
{
  GnomeUIInfo item[] = GNOMEUIINFO_ITEM_NONE(label, tooltip, a_callback);
  menu[where] = item[0];
}

// Add a simple item to the menu at the position indicated by
// where. There is no icon display on the item line, nor shortcut key,
// and no data to be passed to the callback function. The label is
// what will appear in this place in the menu (place an underline
// before the character in the label to be used as meta (accelerator)
// character for the item. The tooltip is a comment that appears in
// the status bar if the application defines one. The last parameter
// is the name of the function to be called when the menu item is
// activated.
void Menu_add_item_data(GnomeUIInfo *menu, int where,
			gchar *label, gchar *tooltip,
			void (*a_callback) (GtkWidget*, gpointer),
			gpointer data)
{
  GnomeUIInfo item[] = GNOMEUIINFO_ITEM_DATA(label, tooltip, a_callback, data,
					     (void *)GNOME_APP_PIXMAP_NONE);
  menu[where] = item[0];
}

// Ending a menu. The where parameter is the index in the array of
// menu items where the end of menu is placed.
void Menu_end(GnomeUIInfo *menu, int where)
{
  GnomeUIInfo item[] = GNOMEUIINFO_END;
  menu[where] = item[0];
}

// Adding a separator (horizontal line) to the menu at the position
// indicated by where.
void Menu_add_separator(GnomeUIInfo *menu, int where)
{
  GnomeUIInfo item[] = GNOMEUIINFO_SEPARATOR;
  menu[where] = item[0];
}

// Composing the individual menus.

// Add a file menu (3rd parameter) to the menu bar (first parameter)
// at the beginning.
void Menu_add_file(GnomeUIInfo *menu, GnomeUIInfo *file_menu)
{
  GnomeUIInfo item[] = GNOMEUIINFO_MENU_FILE_TREE(file_menu);
  menu[0] = item[0];
}

// Add a submenu to a menu at the position where. The label is what
// will appear in this place in the menu (place an
//underline before the character in the label to be used as meta
//(accelerator) character for the item.
void Menu_add_subtree(GnomeUIInfo *menu, int where, 
		      GnomeUIInfo *sub_menu, gchar *label)
{
  GnomeUIInfo item[] = GNOMEUIINFO_SUBTREE(label, sub_menu);
  menu[where] = item[0];
}

// Add a save as item to a menu with a callback.
void Menu_add_saveas(GnomeUIInfo *menu,
		     void (*a_callback) (GtkWidget*, gpointer), 
		     gpointer data, int where)
{
  GnomeUIInfo item[] = GNOMEUIINFO_MENU_SAVE_AS_ITEM(a_callback, data);
  menu[where] = item[0];
}
