/******************************************************************************
* FILE:   gui_handle.h
*         The functions that handle the interface itself.
*
* Author: Dana Vrajitoru, IUSB
* Class:  C481 B581 Computer Graphics
******************************************************************************/

#ifndef GUI_HANDLE_H
#define GUI_HANDLE_H

// Callback function for the exit button on the top-right of the
// window.
gint Event_delete(GtkWidget *widget, GdkEvent *event, gpointer data);

// Callback function for the explicit exit called by the user from the
// File menu.
gint Event_destroy(GtkWidget *widget, GdkEvent *event, gpointer data);

// Create the data structure for the menus.
void Make_menus(GtkWidget *app);

// Inserts the actual menus in the application window.
void Insert_menu(GtkWidget *app);

// Callback for any kind of event that implies redrawing the window.
void Callback_new(GtkWidget *widget, gpointer data);

// Redraws the window.
gint Event_draw(GtkWidget *widget, GdkEvent *event, gpointer data);

#endif
