/******************************************************************************
* FILE:   gui_handle.cc
*         The functions that handle the interface itself.
*
* Author: Dana Vrajitoru, IUSB
* Class:  C481 B581 Computer Graphics
******************************************************************************/

#include <gnome.h>
#include "gui_handle.h"
#include "menu_handle.h"
#include "draw.h"
#include "main.h"

GnomeUIInfo file_menu[4], menubar[2];

// Callback function for the exit button on the top-right of the
// window.
gint Event_delete(GtkWidget *widget, GdkEvent *event, gpointer data)
{
  gtk_main_quit();
  return(0);
}

// Callback function for the explicit exit called by the user from the
// File menu.
gint Event_destroy(GtkWidget *widget, GdkEvent *event, gpointer data)
{
  gtk_main_quit();
  return(0);
}

// Create the data structure for the menus.
void Make_menus(GtkWidget *area)
{
  Menu_add_item_data(file_menu, 0, "_New game",
		     "New game", Callback_new,
		     gpointer(area));

  Menu_add_separator(file_menu, 1);
  Menu_add_exit(file_menu, 2);
  Menu_end(file_menu, 3);

  Menu_add_file(menubar, file_menu);
  Menu_end(menubar, 1);
}

gint Event_draw(GtkWidget *widget, GdkEvent *event, gpointer data)
{  
  //Test_pixmaps(widget);
  // pixmap_origin_X, pixmap_origin_y, are_origin_x, are_origin_y,
  // drawing_width, drawing_height
  Draw(widget);
}

// Inserts the actual menus in the application window.
void Insert_menu(GtkWidget *app)
{
  gnome_app_create_menus (GNOME_APP (app), menubar);
}

// Callback for any kind of event that implies redrawing the window.
void Callback_new(GtkWidget *widget, gpointer data)
{
  New_game(GTK_WIDGET(data));
}
