/******************************************************************************
* FILE:   draw.h
*         Drawing functions.
*
* Author: Dana Vrajitoru, IUSB
* Class:  C481 B581 Computer Graphics
******************************************************************************/

#ifndef DRAW_H
#define DRAW_H

#include "tetris_brick.h"

// Redraws the entire window.
void Draw(GtkWidget *area);

// Initializes the data in the pixmaps
void Init_pixmaps(GtkWidget *widget);

// Initialize the graphical context based on the drawing area.
void Init_gc(GtkWidget *area);

// A test function for the various pixmaps.
void Test_pixmaps(GtkWidget *area);

// Draws the table on the main pixmap.
void Draw_table(Table_type table, int width=T_WIDTH, int height=T_HEIGHT);

// Draws a rectangle of the given color, with a lighter border on top
// and a darker border at the bottom.
void Draw_rect_border(GdkPixmap *pixmap, GdkColor color, 
		      int width=C_WIDTH, int height=C_HEIGHT);

// Draws a white rectangle.
void Draw_space(GdkPixmap *pixmap, 
		int width=C_WIDTH, int height=C_HEIGHT);

// Draws spaces over a tetris brick on the main pixmap.
void Erase_brick(Tetris_brick &the_brick, int old_x, int old_y);

// Draws the brick at the position stored in the object itself.
void Draw_brick(Tetris_brick &the_brick);

#endif
